<?php

/* --------------------------------------------------------------
   HubListVaultThemeContentView.inc.php 2025-07-29
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2025 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

/**
 * Class representing a gambio hub vault list content view
 */
class HubListVaultThemeContentView extends ThemeContentView
{
    protected $vault_data_array = [];

    /**
     * HubListVaultThemeContentView constructor.
     */
    public function __construct()
    {
        parent::__construct();

        $this->set_template_dir(DIR_FS_CATALOG . HubVaultControllerConfiguration::TEMPLATE_DIRECTORY);
        $this->set_content_template('HubListVault.html');
        $this->set_flat_assigns(true);
        $this->set_caching_enabled(false);

    }

    public function prepare_data()
    {
        $this->content_array['vault_data']       = $this->vault_data_array;
        $this->content_array['BUTTON_BACK_LINK'] = xtc_href_link(FILENAME_ACCOUNT, '', 'SSL');
        $this->content_array['BUTTON_NEW_URL']   = xtc_href_link(FILENAME_ADDRESS_BOOK_PROCESS, '', 'SSL');
    }

    public function set_vault_data_array(array $vault_data_raw)
    {
        if (isset($vault_data_raw['saved_cards']) || isset($vault_data_raw['saved_paypal'])) {
            $this->vault_data_array = $this->format_vault_data($vault_data_raw);
        }
    }

    protected function format_vault_data($rawData)
    {
        $formattedData = [];

        if (!is_array($rawData)) {
            return $formattedData;
        }

        // Add PayPal payments first (as per requirement)
        if (isset($rawData['saved_paypal']) && is_array($rawData['saved_paypal'])) {
            foreach ($rawData['saved_paypal'] as $tokenId => $payment) {
                $formattedData[] = $this->format_paypal_payment($payment, $tokenId);
            }
        }

        // Add credit card payments
        if (isset($rawData['saved_cards']) && is_array($rawData['saved_cards'])) {
            foreach ($rawData['saved_cards'] as $tokenId => $payment) {
                $formattedData[] = $this->format_credit_card_payment($payment, $tokenId);
            }
        }

        return $formattedData;
    }

    protected function format_paypal_payment($payment, $tokenId)
    {
        return [
            'TYPE'              => 'paypal',
            'IMAGE'             => isset($payment['logo_url']) ? $payment['logo_url'] : 'image paypal',
            'ACCOUNT'           => isset($payment['email']) ? $payment['email'] : '',
            'NAME'              => isset($payment['name']) ? $payment['name'] : '',
            'BUTTON_DELETE_URL' => 'shop.php?do=HubVault/Delete&vault_id=' . $tokenId,
            'PAYMENT_ID'        => $tokenId,
            'TOKEN_ID'          => $tokenId
        ];
    }

    protected function format_credit_card_payment($payment, $tokenId)
    {
        return [
            'TYPE'              => 'credit_card',
            'IMAGE'             => isset($payment['logo_url']) ? $payment['logo_url'] : 'image credit card',
            'CARDHOLDER_NAME'   => isset($payment['name']) ? $payment['name'] : '',
            'MASKED_NUMBER'     => isset($payment['last_digits_title']) ? $payment['last_digits_title'] : '',
            'EXPIRY_DATE'       => isset($payment['expiry']) ? $payment['expiry'] : '',
            'BRAND'             => isset($payment['brand']) ? $payment['brand'] : '',
            'TITLE'             => isset($payment['title']) ? $payment['title'] : '',
            'INFO_TEXT'         => isset($payment['info_text']) ? $payment['info_text'] : '',
            'IS_EXPIRED'        => isset($payment['is_expired']) ? $payment['is_expired'] : false,
            'BUTTON_DELETE_URL' => 'shop.php?do=HubVault/Delete&vault_id=' . $tokenId,
            'PAYMENT_ID'        => $tokenId,
            'TOKEN_ID'          => $tokenId
        ];
    }

}
